msg_focus_so = "<strong class='color-text'>Chỉ được nhập số 0-9.</strong>";
msg_focus_chuso_4_10 = "<strong class='color-text'>Phải từ 4-10 ký tự, có thể sử dụng chữ cái, chữ số, gạch dưới.</strong>";
msg_focus_chuso = "<strong class='color-text'>Có thể sử dụng chữ cái, chữ số, gạch dưới.</strong>";
msg_focus_tel = "<strong class='color-text'>Nhập đúng SĐT di động đang sử dụng để nhận được hỗ trợ về tài khoản, mật khẩu khi cần.</strong>";
msg_focus_verify = "<strong class='color-text'>Nhập lại 6 kí tự trong hình trên.</strong>";

msg_check_so_error = "<strong class='color-primary'>Chỉ được sử dụng số 0-9.</strong>";
msg_check_chuso_error = "<strong class='color-primary'>Chỉ được sử dụng chữ cái, chữ số, dấu gạch dưới.</strong>";
msg_check_chuso_4_10_error = "<strong class='color-primary'>Phải từ 4-10 ký tự. Chỉ được sử dụng chữ cái, chữ số, dấu gạch dưới.</strong>";
msg_check_chuso_4_20_error = "<strong class='color-primary'>Phải từ 4-20 ký tự. Chỉ được sử dụng chữ cái, chữ số, dấu gạch dưới.</strong>";

filter_so = /^[0-9]+$/;
filter_chuso = /^[a-zA-Z0-9_]+$/;
filter_email = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
filter_tel = /^0[0-9]{9,10}$/;


function focus_so(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;
    if (value.length == 0) {
        s.innerHTML = msg_focus_so;
        error = 1;
    }
    return error;
}

function focus_chuso_4_10(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;
    if (value.length == 0) {
        s.innerHTML = msg_focus_chuso_4_10;
        error = 1;
    }
    return error;
}

function focus_chuso(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;
    if (value.length == 0) {
        s.innerHTML = msg_focus_chuso;
        error = 1;
    }
    return error;
}

function focus_tel(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;
    if (value.length == 0) {
        s.innerHTML = msg_focus_tel;
        error = 1;
    }
    return error;
}

function focus_codeverify(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;
    if (value.length == 0) {
        s.innerHTML = msg_focus_verify;
        error = 1;
    }
    return error;
}


function onblur_check_repass(value1, value2, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;
    if (value1 != value2) {
        s.innerHTML = "<strong class='color-primary'>Xác minh mật khẩu không đúng.</strong>";
        error = 1;
    } else s.innerHTML = '';
    return error;
}


function check_so(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (!filter_so.test(value)) {
        s.innerHTML = msg_check_so_error;
        error = 1;
    } else s.innerHTML = '';

    return error;
}

function check_chuso(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (!filter_chuso.test(value)) {
        s.innerHTML = msg_check_chuso_error;
        error = 1;
    } else s.innerHTML = '';

    return error;
}

function check_chuso_4_10(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (!filter_chuso.test(value) || (value.length < 4 || value.length > 10)) {
        s.innerHTML = msg_check_chuso_4_10_error;
        error = 1;
    } else s.innerHTML = '';

    return error;
}

function check_chuso_4_20(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (!filter_chuso.test(value) || (value.length < 4 || value.length > 20)) {
        s.innerHTML = msg_check_chuso_4_20_error;
        error = 1;
    } else s.innerHTML = '';
    return error;
}

function check_select(value, max_select_value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (value < 1 || value > max_select_value) {
        s.innerHTML = "<strong class='color-primary'>Chưa chọn.</strong>";
        error = 1;
    } else s.innerHTML = '';
    return error;
}

function check_email(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (!filter_email.test(value)) {
        s.innerHTML = "<strong class='color-primary'>Không đúng dạng Email</strong>";
        error = 1;
    } else s.innerHTML = '';
    return error;
}

function check_tel(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (!filter_tel.test(value)) {
        s.innerHTML = "<strong class='color-primary'>Phải điền đúng số điện thoại di động.</strong>";
        error = 1;
    } else s.innerHTML = '';
    return error;
}

function check_codeverify(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (!filter_chuso.test(value) || value.length != 6) {
        s.innerHTML = "<strong class='color-primary'>Mã kiểm tra phải có 6 kí tự</strong>";
        error = 1;
    } else s.innerHTML = '';
    return error;
}

function btn_check_verify(value, id_msg) {
    if (check_codeverify(value, id_msg) == 1) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin đăng kí !!!");
        return false;
    } else return true;
}

function btn_check_register() {
    var s = document.register;
    var check_error = 0;


    if (check_chuso_4_10(s.username.value, 'msg_username') == 1) {
        check_error++;
        if (check_error == 1) s.username.focus();
    }


    if (check_chuso_4_10(s.passgame.value, 'msg_passgame') == 1) {
        check_error++;
        if (check_error == 1) s.passgame.focus();
    }


    if (check_chuso_4_20(s.pass1.value, 'msg_pass1') == 1) {
        check_error++;
        if (check_error == 1) s.pass1.focus();
    }


    if (check_chuso_4_20(s.pass2.value, 'msg_pass2') == 1) {
        check_error++;
        if (check_error == 1) s.pass2.focus();
    }


    if (check_email(s.email.value, 'msg_email') == 1) {
        check_error++;
        if (check_error == 1) s.email.focus();
    }


    if (check_select(s.quest.value, 8, 'msg_quest') == 1) {
        check_error++;
        if (check_error == 1) s.quest.focus();
    }


    if (check_chuso_4_10(s.ans.value, 'msg_ans') == 1) {
        check_error++;
        if (check_error == 1) s.ans.focus();
    }


    if (check_so(s.sno_numb.value, 'msg_sno_numb') == 1) {
        check_error++;
        if (check_error == 1) s.sno_numb.focus();
    }


    if (check_tel(s.tel.value, 'msg_tel') == 1) {
        check_error++;
        if (check_error == 1) s.tel.focus();
    }


    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin đăng kí !!!");
        return false;
    } else return true;
}

function btn_check_changepass1() {
    var s = document.changepass1;
    var check_error = 0;

    if (check_chuso_4_20(s.pass1new.value, 'msg_pass1new') == 1) {
        check_error++;
        if (check_error == 1) s.pass1new.focus();
    }
    if (onblur_check_repass(s.pass1new.value, s.pass1new_verify.value, 'msg_pass1new_verify') == 1) {
        check_error++;
        if (check_error == 1) s.pass1new_verify.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_changepass2() {
    var s = document.changepass2;
    var check_error = 0;

    if (check_chuso_4_20(s.pass2new.value, 'msg_pass2new') == 1) {
        check_error++;
        if (check_error == 1) s.pass2new.focus();
    }
    if (onblur_check_repass(s.pass2new.value, s.pass2new_verify.value, 'msg_pass2new_verify') == 1) {
        check_error++;
        if (check_error == 1) s.pass2new_verify.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_changepassgame() {
    var s = document.changepassgame;
    var check_error = 0;

    if (check_chuso_4_20(s.passgamenew.value, 'msg_passgamenew') == 1) {
        check_error++;
        if (check_error == 1) s.passgamenew.focus();
    }
    if (onblur_check_repass(s.passgamenew.value, s.passgamenew_verify.value, 'msg_passgamenew_verify') == 1) {
        check_error++;
        if (check_error == 1) s.passgamenew_verify.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_quest() {
    var s = document.changequest;
    var check_error = 0;
    if (check_select(s.quest.value, 'msg_quest') == 1) {
        check_error++;
        if (check_error == 1) s.quest.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_ans() {
    var s = document.changeans;
    var check_error = 0;

    if (check_chuso_4_10(s.ans.value, 'msg_ans') == 1) {
        check_error++;
        if (check_error == 1) s.ans.focus();
    }
    if (onblur_check_repass(s.ans.value, s.ans_verify.value, 'msg_ans_verify') == 1) {
        check_error++;
        if (check_error == 1) s.ans_verify.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_email() {
    var s = document.changeemail;
    var check_error = 0;

    if (check_email(s.email.value, 'msg_email') == 1) {
        check_error++;
        if (check_error == 1) s.email.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_sdtsms() {
    var s = document.changesdt_sms;
    var check_error = 0;

    if (check_tel(s.tel.value, 'msg_tel') == 1) {
        check_error++;
        if (check_error == 1) s.tel.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_sdtinfo() {
    var s = document.changesdt_info;
    var check_error = 0;

    if (check_tel(s.tel.value, 'msg_tel') == 1) {
        check_error++;
        if (check_error == 1) s.tel.focus();
    }
    if (check_chuso_4_20(s.pass2.value, 'msg_pass2') == 1) {
        check_error++;
        if (check_error == 1) s.pass2.focus();
    }
    if (check_email(s.email.value, 'msg_email') == 1) {
        check_error++;
        if (check_error == 1) s.email.focus();
    }
    if (check_select(s.quest.value, 'msg_quest') == 1) {
        check_error++;
        if (check_error == 1) s.quest.focus();
    }
    if (check_chuso_4_10(s.ans.value, 'msg_ans') == 1) {
        check_error++;
        if (check_error == 1) s.ans.focus();
    }
    if (check_tel(s.tel_old.value, 'msg_tel_old') == 1) {
        check_error++;
        if (check_error == 1) s.tel_old.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_chonNV() {
    var s = document.ChonNV;
    var check_error = 0;
    if (check_nv(s.nhanvat.value, 'msg_nhanvat') == 1) {
        check_error++;
        if (check_error == 1) s.nhanvat.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function check_nv(value, id_msg) {
    var s = document.getElementById(id_msg);
    var error = 0;

    if (value == 0) {
        s.innerHTML = "<strong class='color-primary'>Chưa chọn.</strong>";
        error = 1;
    } else s.innerHTML = '';
    return error;
}

function btn_check_rutpoint() {
    var s = document.rutpoint;
    var check_error = 0;
    if ((check_so(s.point.value, 'msg_point') == 1)) {
        check_error++;
        if (check_error == 1) s.point.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_addpoint() {
    var s = document.addpoint;
    var check_error = 0;
    if ((check_so(s.str.value, 'msg_str') == 1)) {
        check_error++;
        if (check_error == 1) s.str.focus();
    }
    if ((check_so(s.dex.value, 'msg_dex') == 1)) {
        check_error++;
        if (check_error == 1) s.dex.focus();
    }
    if ((check_so(s.vit.value, 'msg_vit') == 1)) {
        check_error++;
        if (check_error == 1) s.vit.focus();
    }
    if ((check_so(s.ene.value, 'msg_ene') == 1)) {
        check_error++;
        if (check_error == 1) s.ene.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_thevtc() {
    var s = document.vpoint_vtc;
    var check_error = 0;
    if ((check_so(s.card_num.value, 'msg_card_num') == 1)) {
        check_error++;
        if (check_error == 1) s.card_num.focus();
    } else if (s.card_num.value.length != 12) {
        check_error++;
        document.getElementById('msg_card_num').innerHTML = "<strong class='color-primary'>Mã thẻ phải có 12 chữ số.</strong>";
        if (check_error == 1) s.card_num.focus();
    }
    if (s.card_serial.value.length != 12) {
        check_error++;
        document.getElementById('msg_card_serial').innerHTML = "<strong class='color-primary'>Serial phải có 12 kí tự.</strong>";
        if (check_error == 1) s.card_serial.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function btn_check_thegate() {
    var s = document.vpoint_gate;
    var check_error = 0;
    if ((check_so(s.card_num.value, 'msg_card_num') == 1)) {
        check_error++;
        if (check_error == 1) s.card_num.focus();
    } else if (s.card_num.value.length != 10) {
        check_error++;
        document.getElementById('msg_card_num').innerHTML = "<strong class='color-primary'>Mã thẻ phải có 10 chữ số.</strong>";
        if (check_error == 1) s.card_num.focus();
    }
    if (s.card_serial.value.length != 10) {
        check_error++;
        document.getElementById('msg_card_serial').innerHTML = "<strong class='color-primary'>Serial phải có 10 kí tự.</strong>";
        if (check_error == 1) s.card_serial.focus();
    }

    if (check_error > 0) {
        alert("Có lỗi. Vui lòng kiểm tra lại thông tin !!!");
        return false;
    } else return true;
}

function _loading(show) {
    if (show) {
        $(".loading").addClass('active');
    } else {
        $(".loading").removeClass('active');
    }
}
function initJquery(){
	console.log('init jquery');
	$('#Main .tooltip').tooltipster({
		delay: 0,
		theme: 'tooltipster-punk',
		animation: 'grow',
	});
	$('#Main .owl-carousel').owlCarousel({
	    loop:true,
	    margin:0,
	    nav:true,
	    items: 1,
	    autoplay: true,
	    smartSpeed: 500,
	    navText: ['←','→']
	});
}
var xhr;

function _pageload(url, data, id) {
    if (xhr && xhr.readystate != 4) {
        xhr.abort();
    }
    xhr = $.ajax({
        url: url,
        type: "GET",
        data: data,
        cache: false,
        beforeSend: function() {
            _loading(1);
            $('#loading').show();
            $('#notice').hide();
        },
        success: function(html) {
            _loading(0);
            $('#loading').hide();
            $('#' + id).html(html);
            $('#' + id).fadeIn('medium');
            _link_notajax();
            initJquery();
            $('.dark-bar').removeClass('show');
        }
    });
}

function _link_notajax() {
    var location = window.location.href;
    if (location.indexOf("index.php?mod") > 0) {
        var location_split = location.split('/');
        var location_arr_length = location_split.length;
        var url_host = '';
        for (i = 0; i < location_arr_length - 1; i++) {
            url_host += location_split[i] + "/";
        }
        $('a').each(function() {
            var thishref = $(this).attr('href');
            $(this).removeAttr("rel").attr('href', url_host + thishref);
        });
    }
}
$(document).ready(function() {
    $('body').on('click', 'input[rel=ajax]', function() {
        var url = $(this).attr('href');
        if (url.indexOf('#') != -1) {
            var c_url = url.split('#');
            var module = c_url ? c_url[1] : '#';
            _pageload('index2.php?mod=' + module, '', 'Main');
            var mod_split = module.split('&');
            var mod_pri = mod_split ? mod_split[0] : module;
            var menuactive = mod_pri;
            if (mod_pri = 'event') {
                var act = mod_split[1];
                switch (act) {
                    case 'act=giftcode_rs':
                    case 'act=giftcode_week':
                    case 'act=giftcode_month':
                    case 'act=giftcode_tanthu':
                    case 'act=giftcode_change':
                    case 'act=giftcode_history':
                        menuactive = 'giftcode';
                        break;
                }
            }
            $('#mainmenu a[rel=menuajax]').removeClass('menuactive');
            $('#mainmenu a[href=#' + menuactive + ']').addClass('menuactive');
        }
    });
    $("body").on('click', '#box-character li[data-char]', function() {
        var char_choise = $(this).attr("data-char");
        $("#box-character li[data-char]").removeClass('active');
        $(this).addClass('active');
        var dataString = "char_choise=" + char_choise;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=char_choise",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $('.loading').show();
            },
            complete: function() {
                $('.loading').hide();
                $(".dropdown-select").fadeOut('fast');
                $(".guideShow").removeClass('guideShow');
            },
            success: function(html) {
            	
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#char_view").html(html_split[2]);
                    window.location.href = 'index.php#char_manager&time=' + (new Date).getTime();
                    //window.location.reload(1);
                    $("#choise_char_msg").html(""); /* Quest Daily */
                    if (html_split[3] == 0) {
                        $("#qdl_un").removeClass().html('');
                        $("#char_note").removeClass();
                    } else {
                        $("#qdl_un").removeClass().addClass('badge badge-primary').html(html_split[3]);
                        $("#char_note").removeClass().addClass('note-evt');
                    } /* Event > Nhan thuong */
                    if (html_split[4] == 0) {
                        $("#award_un").removeClass().html('');
                        $("#event_note").removeClass();
                    } else {
                        $("#award_un").removeClass().addClass('badge badge-primary').html(html_split[4]);
                        $("#event_note").removeClass().addClass('note-evt');
                    }
                } else {
                    $("#choise_char_msg").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', "#reload_char", function() {
        var dataString = "";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=char_choise",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $('#loading').show();
            },
            complete: function() {
                $('#loading').hide();
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    window.location.href = 'index.php#char_manager&' + (new Date).getTime();
                    $("#choise_char_msg").html(""); /* Quest Daily */
                    if (html_split[3] == 0) {
                        $("#qdl_un").removeClass().html('');
                        $("#char_note").removeClass();
                    } else {
                        $("#qdl_un").removeClass().addClass('badge').html(html_split[3]);
                        $("#char_note").removeClass().addClass('note-evt');
                    } /* Event > Nhan thuong */
                    if (html_split[4] == 0) {
                        $("#award_un").removeClass().html('');
                        $("#event_note").removeClass();
                    } else {
                        $("#award_un").removeClass().addClass('badge').html(html_split[4]);
                        $("#event_note").removeClass().addClass('note-evt');
                    }
                } else {
                    $("#choise_char_msg").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', "#btn_rs", function() {
        var dataString = "action=reset";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=char_rs",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#rs_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#rs_err").html("");
                $("#btn_rs").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#rs_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("<nbb>");
                if (html_split[1] == "OK") {
                    $("#rs_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#rs_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_rs").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "#btn_rs_over", function() {
        var dataString = "action=reset_over";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=char_rs",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#rs_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#rs_err").html("");
                $("#btn_rs_over").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#rs_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("<nbb>");
                if (html_split[1] == "OK") {
                    $("#rs_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#rs_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_rs_over").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "#btn_rsvip", function() {
        var tiente = $('input[name=tiente]:checked').val();
        var dataString = "action=reset_vip&tiente=" + tiente;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=char_rs",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#rs_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#rs_err").html("");
                $("#btn_rsvip").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#rs_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("<nbb>");
                if (html_split[1] == "OK") {
                    $("#rs_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                    $("#head_gcoin").html(html_split[3]);
                    $("#head_gcoin_km").html(html_split[4]);
                    $("#head_vpoint").html(html_split[5]);
                    $("#head_vpoint_km").html(html_split[6]);
                } else {
                    $("#rs_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_rsvip").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "#btn_rs_over_vip", function() {
        var tiente = $('input[name=tiente]:checked').val();
        var dataString = "action=reset_over_vip&tiente=" + tiente;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=char_rs",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#rs_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#rs_err").html("");
                $("#btn_rs_over_vip").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#rs_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("<nbb>");
                if (html_split[1] == "OK") {
                    $("#rs_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                    $("#head_gcoin").html(html_split[3]);
                    $("#head_gcoin_km").html(html_split[4]);
                    $("#head_vpoint").html(html_split[5]);
                    $("#head_vpoint_km").html(html_split[6]);
                } else {
                    $("#rs_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_rs_over_vip").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "input[name='tiente']", function() {
        var tiente = $('input[name=tiente]:checked').val();
        if (tiente == 'gcoin') {
            $('#use_gcoin').show();
            $('#use_vpoint').hide();
        } else {
            $('#use_gcoin').hide();
            $('#use_vpoint').show();
        }
    });
    $('body').on('change', "input[name='item']", function() {
        var x = $("input[name='item']:checked").attr('x');
        var y = $("input[name='item']:checked").attr('y');
        var itemperrow = Math.floor(8 / x);
        var itempercolumn = Math.floor(8 / y);
        var slgmax = itemperrow * itempercolumn;
        var slgitem_choise = "";
        for (i = 1; i <= slgmax; i++) {
            slgitem_choise += "<option value='" + i + "'>" + i + "</option>";
        }
        $('#slg').html(slgitem_choise);
    });
    var timeout = null;
    $('body').on('keyup', ".addpoint", function() {
        clearTimeout(timeout);
        timeout = setTimeout(function() {
            var str = $("#str").val();
            var dex = $("#dex").val();
            var vit = $("#vit").val();
            var ene = $("#ene").val();
            var com = $("#com").val();
            $.get("ajax_action.php", {
                ajax: "addpoint",
                istr: str,
                idex: dex,
                ivit: vit,
                iene: ene,
                icom: com
            }, function(data) {
                var data_split = data.split("|");
                if (data_split[1] == "1") {
                    $("#point_total").text(data_split[2]).removeClass('badge-primary').addClass('badge-blue');
                    $("#SubmitAddPoint").removeClass("btn-default").addClass("btn-green").removeAttr('disabled');
                    $("#addpoint_err").html("");
                } else {
                    if (!data_split[2]) {
                        $("#addpoint_err").html("<strong class='color-primary'>" + data + "</strong>");
                    } else {
                        $("#point_total").text(data_split[2]).removeClass('badge-blue').addClass('badge-primary');
                        $("#SubmitAddPoint").removeClass("btn-green").addClass("btn-default").attr('disabled', 'disabled');
                        $("#addpoint_err").html("");
                    }
                }
                $("#str_view").html(data_split[3]);
                $("#dex_view").html(data_split[4]);
                $("#vit_view").html(data_split[5]);
                $("#ene_view").html(data_split[6]);
                $("#com_view").html(data_split[7]);
            });
        }, 500);
    });
    $('body').on('change', "#chao", function() {
        var chao = $("#chao").val();
        var cre = $("#cre").val();
        var blue = $("#blue").val();
        var lvitem = $("#lvitem").html();
        $.get("ajax_action.php", {
            ajax: "itemuplv",
            ichao: chao,
            icre: cre,
            iblue: blue,
            ilvitem: lvitem
        }, function(data) {
            $("#percent").html(data);
        });
    });
    $('body').on('change', "#cre", function() {
        var chao = $("#chao").val();
        var cre = $("#cre").val();
        var blue = $("#blue").val();
        var lvitem = $("#lvitem").html();
        $.get("ajax_action.php", {
            ajax: "itemuplv",
            ichao: chao,
            icre: cre,
            iblue: blue,
            ilvitem: lvitem
        }, function(data) {
            $("#percent").html(data);
        });
    });
    $('body').on('change', "#blue", function() {
        var chao = $("#chao").val();
        var cre = $("#cre").val();
        var blue = $("#blue").val();
        var lvitem = $("#lvitem").html();
        $.get("ajax_action.php", {
            ajax: "itemuplv",
            ichao: chao,
            icre: cre,
            iblue: blue,
            ilvitem: lvitem
        }, function(data) {
            $("#percent").html(data);
        });
    });
    $('body').on('click', ".epitem_reg", function() {
        var serial = $(this).attr("serial");
        var dataString = "action=reg&iserial=" + serial;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=event_epitem",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_" + serial).html("<img src='images/loading1.gif' border='0' />");
                $("#err_" + serial).html("");
            },
            complete: function() {
                $("#loading_" + serial).html("");
            },
            success: function(html) {
                if (html == 'OK') {
                    $("#td_" + serial).html('Ðăng ký thành công');
                } else {
                    $("#err_" + serial).html(html);
                }
            }
        });
        return false;
    });
    $('body').on('click', ".epitem_update", function() {
        var serial = $(this).attr("serial");
        var dataString = "action=update&iserial=" + serial;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=event_epitem",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_" + serial).html("<img src='images/loading1.gif' border='0' />");
                $("#err_" + serial).html("");
            },
            complete: function() {
                $("#loading_" + serial).html("");
            },
            success: function(html) {
                var html_split = html.split("<nbb>");
                if (html_split[1] == "OK") {
                    if (html_split[2] == "OK") {
                        $("#td_" + serial).html('<strong><font color="#00FFFF">Ðã hoàn thành</font></strong><br />' + html_split[3]).css("background-color", "#121212");
                    } else {
                        $("#err_" + serial).html(html_split[2]);
                    }
                } else {
                    $("#err_" + serial).html(html);
                }
            }
        });
        return false;
    });
    $('body').on('click', ".lockitem_lock", function() {
        var serial = $(this).attr("serial");
        var vitri = $(this).attr("vitri");
        var opd = $("#opd_" + vitri).val();
        if (serial.length == 0) {
            alert('Serial Item không hợp lệ');
        } else if (opd.length == 0) {
            alert('Chưa nhập mật khẩu OPD');
        } else {
            var dataString = "action=lock&iserial=" + serial + "&vitri=" + vitri + "&opd=" + opd;
            $.ajax({
                type: "GET",
                url: "ajax_action.php?ajax=nv_lockitem",
                data: dataString,
                cache: false,
                beforeSend: function() {
                    $("#loading_" + vitri).html("<img src='images/loading1.gif' border='0' />");
                    $("#err_" + vitri).html("");
                },
                complete: function() {
                    $("#loading_" + vitri).html("");
                },
                success: function(html) {
                    var html_split = html.split("|");
                    if (html_split[1] == "OK") {
                        $("#lockinfo_" + vitri).html("<strong class='color-blue'>Item đã bảo vệ</strong>");
                        $("#button_" + vitri).html("<input type='button' vitri='" + vitri + "' class='lockitem_unlock' value='Hủy Bảo vệ Item' /> <strong class='color-blue'>Miễn Phí</strong>");
                        $("#head_gcoin").html(html_split[2]);
                        $("#head_gcoin_km").html(html_split[3]);
                    } else {
                        $("#err_" + vitri).html(html);
                    }
                }
            });
        }
        return false;
    });
    $('body').on('click', ".lockitem_unlock", function() {
        var vitri = $(this).attr("vitri");
        var opd = $("#opd_" + vitri).val();
        var price_lock = $("#price_lock").html();
        if (vitri.length == 0) {
            alert('Vị Trí Item không hợp lệ');
        } else if (opd.length == 0) {
            alert('Chưa nhập mật khẩu OPD');
        } else {
            var dataString = "action=unlock&vitri=" + vitri + "&opd=" + opd;
            $.ajax({
                type: "GET",
                url: "ajax_action.php?ajax=nv_lockitem",
                data: dataString,
                cache: false,
                beforeSend: function() {
                    $("#loading_" + vitri).html("<img src='images/loading1.gif' border='0' />");
                    $("#err_" + vitri).html("");
                },
                complete: function() {
                    $("#loading_" + vitri).html("");
                },
                success: function(html) {
                    var html_split = html.split("<nbb>");
                    if (html_split[1] == "OK") {
                        $("#lockinfo_" + vitri).html("<strong class='color-primary'><strong>Item chưa được bảo vệ</strong></strong>");
                        $("#button_" + vitri).html("<input type='button' vitri='" + vitri + "' serial='" + html_split[2] + "' class='lockitem_lock' value='Bảo vệ Item' /> " + price_lock);
                    } else {
                        $("#err_" + vitri).html(html);
                    }
                }
            });
        }
        return false;
    });
    $('body').on('click', ".bid_dgn", function() {
        var bidid = $(this).attr("bidid");
        var price_min = $(this).attr("price_min");
        var bid_mod = $(this).attr("bid_mod");
        var bid = $("#bid_" + bidid).val();
        bid = parseInt(bid);
        if (bid < price_min) {
            alert('Giá Đấu ' + bid + ' phải lớn hơn hoặc bằng Giá đấu nhỏ nhất');
        } else if (bid % bid_mod != 0) {
            alert('Giá đấu ' + bid + ' phải chia hết cho ' + bid_mod);
        } else {
            var dataString = "action=bid&bidid=" + bidid + "&bid=" + bid;
            $.ajax({
                type: "GET",
                url: "ajax_action.php?ajax=com_daugianguoc",
                data: dataString,
                cache: false,
                beforeSend: function() {
                    $("#loading_" + bidid).html("<img src='images/loading1.gif' border='0' />");
                    $("#notice_" + bidid).html("");
                },
                complete: function() {
                    $("#loading_" + bidid).html("");
                },
                success: function(html) {
                    if (html == "OK") {
                        $("#notice_" + bidid).html("<strong class='color-blue'><strong>Đã đấu : " + bid + " Vcent</strong><br />Tài khoản của bạn bị <strong>đóng băng " + bid + " Vcent</strong>. Kết thúc Đấu giá sẽ được hoàn trả.</strong>");
                    } else {
                        $("#notice_" + bidid).html("<strong class='color-primary'><strong>" + html + "</strong></strong>");
                    }
                }
            });
        }
        return false;
    });
    $('body').on('click', ".reward_dgn", function() {
        var bidid = $(this).attr("bidid");
        var dataString = "action=reward&bidid=" + bidid;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=com_daugianguoc",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_reward_" + bidid).html("<img src='images/loading1.gif' border='0' />");
                $("#reward_err_" + bidid).html("")
            },
            complete: function() {
                $("#loading_reward_" + bidid).html("");
            },
            success: function(html) {
                if (html == "OK") {
                    $("#reward_" + bidid).html("<strong class='color-blue'><strong>Đã nhận</strong></strong>");
                } else {
                    $("#reward_err_" + bidid).html("<strong class='color-primary'><strong>" + html + "</strong></strong>");
                }
            }
        });
        return false;
    });
    $('body').on('click', '.listbid', function() {
        $(this).fancybox({
            'titlePosition': 'inside',
            'transitionIn': 'none',
            'transitionOut': 'none'
        }).click();
        return false;
    });
    $('body').on('click', ".dgn_bidding_view", function() {
        var bidid = $(this).attr('bidid');
        var dataString = "action=bidding_view&bidid=" + bidid;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=com_daugianguoc",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_bidding_view_" + bidid).html("<img src='images/loading1.gif' border='0' />");
                $("#notice_bidding_view_" + bidid).html("");
            },
            complete: function() {
                $("#loading_bidding_view_" + bidid).html("");
            },
            success: function(html) {
                $("#notice_bidding_view_" + bidid).html(html);
            }
        });
        return false;
    });
    $('body').on('click', ".close_bidding_view", function() {
        var bidid = $(this).attr('bidid');
        $('#notice_bidding_view_' + bidid).html("");
        return false;
    });
    $('body').on('click', ".itembid_up", function() {
        var vitri = $(this).attr('vitri');
        $("#itembid_unactive_" + vitri).slideUp();
        $("#itembid_active_" + vitri).slideDown();
        return false;
    });
    $('body').on('click', ".itembid_down", function() {
        var vitri = $(this).attr('vitri');
        $("#itembid_unactive_" + vitri).slideDown();
        $("#itembid_active_" + vitri).slideUp();
        return false;
    });
    $('body').on('click', ".itembid_send", function() {
        var vitri = $(this).attr('vitri');
        var item_code = $(this).attr('item_code');
        var price_min = $("#price_min_" + vitri).val();
        price_min = parseInt(price_min);
        var price_max = $("#price_max_" + vitri).val();
        price_max = parseInt(price_max);
        var bidday = $("#bidday_" + vitri).val();
        bidday = parseInt(bidday);
        var itempass = $("#itempass_" + vitri).val();
        var passopd = $("#passopd_" + vitri).val();
        if (vitri < 0 || vitri > 120) {
            alert('Vị trí Item sai');
        } else if (item_code.length != 32) {
            alert('Item Code sai');
        } else if (price_min <= 0) {
            alert('Giá khởi điểm ' + price_min + ' phải lớn hơn 0 Vcent');
        } else if (price_min % 100 != 0) {
            alert('Giá khởi điểm ' + price_min + ' phải chia hết cho 100');
        } else if (price_max <= price_min) {
            alert('Giá mua đứt ' + price_max + ' phải lớn hơn giá khởi điểm ' + price_min);
        } else if (price_max % 100 != 0) {
            alert('Giá mua đứt ' + price_max + ' phải chia hết cho 100');
        } else {
            var dataString = "action=itembid_send&vitri=" + vitri + "&item_code=" + item_code + "&price_min=" + price_min + "&price_max=" + price_max + "&bidday=" + bidday + "&itempass=" + itempass + "&passopd=" + passopd;
            $.ajax({
                type: "GET",
                url: "ajax_action.php?ajax=com_daugia",
                data: dataString,
                cache: false,
                beforeSend: function() {
                    $("#itembid_send_loading_" + vitri).html("<img src='images/loading1.gif' border='0' />");
                    $("#itembid_send_view_" + vitri).html("");
                },
                complete: function() {
                    $("#itembid_send_loading_" + vitri).html("");
                },
                success: function(html) {
                    if (html == 'OK') {
                        var notice = "<font color='blue'>Item đã được đưa lên sàn đấu giá<br />";
                        if (itempass.length > 0) notice = notice + "Mật khẩu bảo vệ : <strong>" + itempass + "</strong>";
                        notice = notice + "</font><br /><br />";
                        $("#item_" + vitri).html(notice);
                    } else {
                        $("#itembid_send_view_" + vitri).html(html);
                    }
                }
            });
        }
        return false;
    });
    $('body').on('click', ".bid_dg", function() {
        var bidid = $(this).attr("bidid");
        var bid_vpoint = $(this).attr("bid_vpoint");
        var price_max = $(this).attr("price_max");
        var bid = $("#bid_" + bidid).val();
        var itempass = $("#itempass_" + bidid).val();
        bidid = parseInt(bidid);
        bid_vpoint = parseInt(bid_vpoint);
        price_max = parseInt(price_max);
        bid = parseInt(bid);
        if (bid <= bid_vpoint) {
            alert('Giá Đấu ' + bid + ' Vcent phải lớn hơn Giá đấu hiện tại ' + bid_vpoint);
        } else if (bid % 100 != 0) {
            alert('Giá đấu ' + bid + ' Vcent phải chia hết cho 100');
        } else if (bid > price_max) {
            alert('Giá đấu ' + bid + ' Vcent chỉ được bằng ' + price_max + ' Vcent để mua đứt Item.');
        } else {
            var dataString = "action=bid&bidid=" + bidid + "&bid=" + bid + "&itempass=" + itempass + "&bid_vpoint=" + bid_vpoint + "&price_max=" + price_max;
            $.ajax({
                type: "GET",
                url: "ajax_action.php?ajax=com_daugia",
                data: dataString,
                cache: false,
                beforeSend: function() {
                    $("#loading_" + bidid).html("<img src='images/loading1.gif' border='0' />");
                    $("#notice_" + bidid).html("");
                },
                complete: function() {
                    $("#loading_" + bidid).html("");
                },
                success: function(html) {
                    if (html == "OK") {
                        $("#notice_" + bidid).html("<strong class='color-blue'><strong>Đã đấu : " + bid + " Vcent</strong><br />Tài khoản của bạn bị <strong>đóng băng " + bid + " Vcent</strong>. <br />Khi có người trả giá cao hơn, sẽ được hoàn trả.</strong><br /><br />");
                    } else if (html == "OK2") {
                        $("#notice_" + bidid).html("<strong class='color-blue'><strong>Bạn đã mua đứt Item. <br />Vui lòng vào <a href='#com&act=daugia&page=daugia_end' rel='ajax' >Đấu Giá đã tham gia</a> để lấy Item.</strong><br /><br />");
                    } else {
                        $("#notice_" + bidid).html("<strong class='color-primary'><strong>" + html + "</strong></strong>");
                    }
                }
            });
        }
        return false;
    });
    $('body').on('click', ".reward_dg", function() {
        var bidid = $(this).attr("bidid");
        var dataString = "action=reward&bidid=" + bidid;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=com_daugia",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_reward_" + bidid).html("<img src='images/loading1.gif' border='0' />");
                $("#reward_err_" + bidid).html("")
            },
            complete: function() {
                $("#loading_reward_" + bidid).html("");
            },
            success: function(html) {
                if (html == "OK") {
                    $("#reward_" + bidid).html("<strong class='color-blue'><strong>Đã nhận</strong></strong>");
                } else {
                    $("#reward_err_" + bidid).html("<strong class='color-primary'><strong>" + html + "</strong></strong>");
                }
            }
        });
        return false;
    });
    $('body').on('click', ".dg_giahan", function() {
        var bidid = $(this).attr("bidid");
        var bidday = $("#bidday_" + bidid).val();
        var dataString = "action=dg_giahan&bidid=" + bidid + "&bidday=" + bidday;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=com_daugia",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_giahan_" + bidid).html("<img src='images/loading1.gif' border='0' />");
                $("#notice_view_" + bidid).html("")
            },
            complete: function() {
                $("#loading_giahan_" + bidid).html("");
            },
            success: function(html) {
                if (html == "OK") {
                    $("#item_" + bidid).html("<strong class='color-blue'><strong>Đã gia hạn thành công</strong></strong>");
                } else {
                    $("#notice_view_" + bidid).html("<strong class='color-primary'><strong>" + html + "</strong></strong>");
                }
            }
        });
        return false;
    });
    $('body').on('click', ".dg_rutitem", function() {
        var bidid = $(this).attr("bidid");
        var dataString = "action=dg_rutitem&bidid=" + bidid;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=com_daugia",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_rutitem_" + bidid).html("<img src='images/loading1.gif' border='0' />");
                $("#notice_view_" + bidid).html("")
            },
            complete: function() {
                $("#loading_rutitem_" + bidid).html("");
            },
            success: function(html) {
                if (html == "OK") {
                    $("#item_" + bidid).html("<strong class='color-blue'><strong>Đã rút Item thành công</strong></strong>");
                } else {
                    $("#notice_view_" + bidid).html("<strong class='color-primary'><strong>" + html + "</strong></strong>");
                }
            }
        });
        return false;
    });
    $('body').on('click', ".award_receive", function() {
        var award_id = $(this).attr("award_id");
        var dataString = "action=award_receive&award_id=" + award_id;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=event_award",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_" + award_id).html("<img src='images/loading1.gif' border='0' />");
                $("#err_" + award_id).html("")
            },
            complete: function() {
                $("#loading_" + award_id).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    if (html_split[2] <= 0) {
                        $("#award_un").removeClass().html('');
                        $("#event_note").removeClass();
                    } else {
                        $("#award_un").html(html_split[2]);
                    }
                    $("#li_award_" + award_id).removeClass("complete");
                    $("#award_receive_" + award_id).addClass("received").html("Đã nhận");
                } else {
                    $("#err_" + award_id).html("<strong class='color-primary'><strong>" + html + "</strong></strong>");
                }
            }
        });
        return false;
    });
    $('body').on('click', ".tl_select", function() {
        var tltype = $(this).attr("tltype");
        var tl_exp = $(this).val();
        var dataString = "action=money_change&tl_exp=" + tl_exp;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=tuluyen",
            data: dataString,
            cache: false,
            beforeSend: function() {},
            complete: function() {},
            success: function(html) {
                $("#tl_money_" + tltype).html("<strong class='color-primary'>" + html + "</strong>");
            }
        });
        return false;
    });
    $('body').on('click', ".tuluyen", function() {
        var tltype = $(this).attr("tltype");
        var tl_exp = $("#tl_select_" + tltype).val();
        var popupShow = $(this).data('showpopup'); /* Moi Update */
        var dataString = "action=update&tltype=" + tltype + "&tl_exp=" + tl_exp;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=tuluyen",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_tl" + tltype).html("<img src='images/loading1.gif' border='0' />");
                $("#tlsuccess").html("");
                $("#tlerror").html("");
                $("#btn_tl_" + tltype).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_tl" + tltype).html("");
                $("#btn_tl_" + tltype).removeAttr('disabled');
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    var tuluyen_arr = $.parseJSON(html_split[2]);
                    if (tuluyen_arr['tlpoint'] > 0) {
                        $("#tl_point").html(tuluyen_arr['tlpoint']); /* alert('tlpoint_update : '+ tuluyen_arr['tlpoint']); */
                    }
                    if (tuluyen_arr['pp'] > 0) {
                        $("#tl_point_pp").html(tuluyen_arr['pp']);
                        $("#head_pp").html(tuluyen_arr['pp']); /* alert('pp_update : '+ tuluyen_arr['pp']); */
                    }
                    if (tuluyen_arr['pp_extra'] > 0) {
                        $("#tl_point_pp_extra").html(tuluyen_arr['pp_extra']);
                        $("#head_pp_extra").html(tuluyen_arr['pp_extra']); /* alert('pp_extra_update : '+ tuluyen_arr['pp_extra']); */
                    }
                    if (tuluyen_arr['gcoin'] > 0) {
                        $("#head_gcoin").html(tuluyen_arr['gcoin']);
                    }
                    if (tuluyen_arr['vpoint'] > 0) {
                        $("#head_vpoint").html(tuluyen_arr['vpoint']);
                    }
                    if (tuluyen_arr['gcoin_km'] > 0) {
                        $("#head_gcoin_km").html(tuluyen_arr['gcoin_km']);
                    }
                    if (tuluyen_arr['vpoint_km'] > 0) {
                        $("#head_vpoint_km").html(tuluyen_arr['vpoint_km']);
                    }
                    switch (tuluyen_arr['tltype']) {
                        case 'str':
                            tuluyen_arr['name'] = 'Sức Mạnh';
                            break;
                        case 'agi':
                            tuluyen_arr['name'] = 'Nhanh Nhẹn';
                            break;
                        case 'vit':
                            tuluyen_arr['name'] = 'Thể Lực';
                            break;
                        default:
                            tuluyen_arr['name'] = 'Năng Lượng';
                    }
                    if (tuluyen_arr['tangcap'] == 1) {
                        $("#tl_money_" + tuluyen_arr['tltype']).html('0');
                        $("#tlexp_" + tuluyen_arr['tltype']).html('<font color="blue">' + tuluyen_arr['exp'] + '</font>');
                        $("#btn_tl" + tuluyen_arr['tltype']).html('<div class="group-popup"><div class="box-popup box-popup-red" data-popup="popup-click-' + tuluyen_arr['tltype'] + '"></div><input data-showpopup="' + tuluyen_arr['tltype'] + '" type="button" value="Thăng Cấp" class="tl_thangcap btn btn-green btn-block btn-lg" id="btn_tc_' + tuluyen_arr['tltype'] + '" tltype="' + tuluyen_arr['tltype'] + '" /><br /><strong><font color="red">Chúc Phúc : <span id="tlcp_' + tuluyen_arr['tltype'] + '">0</span> %</font></strong></div>');
                        $("#btn_tl_random").attr('disabled', 'disabled');
                        $("#progress_bar_" + tuluyen_arr['tltype']).width('100%');
                    } else {
                        $("#tlexp_" + tuluyen_arr['tltype']).html(tuluyen_arr['exp']).slideDown('slow');
                        $("#progress_bar_" + tuluyen_arr['tltype']).width(tuluyen_arr['tl_percent_new'] + "%");
                    }
                    var ss_html = "<div class='color-green'>Tu luyện <strong>" + tuluyen_arr['name'] + "</strong> thành công<br />Điểm Tu Luyện tăng lên <strong>" + tuluyen_arr['exp'] + " Điểm</strong></div>"; /*$("#tlsuccess").html();*/
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-green').html(ss_html);
                } else {
                    /*console.log(tltype);$("#tlerror").html("<div class='color-primary'>"+ html +"</div>");*/
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-red').html(html);
                }
            }
        });
        return false;
    });
    $('body').on('click', ".tl_thangcap", function() {
        var tltype = $(this).attr("tltype");
        var popupShow = $(this).data('showpopup'); /* Moi Update */
        var dataString = "action=thangcap&tltype=" + tltype;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=tuluyen",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_tl" + tltype).html("<img src='images/loading1.gif' border='0' />");
                $("#tlsuccess").html("");
                $("#tlerror").html("");
                $("#btn_tc_" + tltype).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_tl" + tltype).html("");
                $("#btn_tc_" + tltype).removeAttr('disabled');
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    var tuluyen_arr = $.parseJSON(html_split[2]);
                    $("#tl_point").html(tuluyen_arr['tlpoint']);
                    if (tuluyen_arr['gcoin'] > 0) {
                        $("#head_gcoin").html(tuluyen_arr['gcoin']);
                    }
                    if (tuluyen_arr['vpoint'] > 0) {
                        $("#head_vpoint").html(tuluyen_arr['vpoint']);
                    }
                    if (tuluyen_arr['gcoin_km'] > 0) {
                        $("#head_gcoin_km").html(tuluyen_arr['gcoin_km']);
                    }
                    if (tuluyen_arr['vpoint_km'] > 0) {
                        $("#head_vpoint_km").html(tuluyen_arr['vpoint_km']);
                    }
                    if (tuluyen_arr['tangcap'] == 1) {
                        $("#tlcap_" + tltype).html(tuluyen_arr['tl_cap']);
                        $("#tlpoint_" + tltype).html(tuluyen_arr['tl_point']);
                        $("#tlexp_" + tltype).html(tuluyen_arr['tl_exp']);
                        $("#tlexpnext_" + tltype).html(tuluyen_arr['tl_exp_next']);
                        $("#tlpointnext_" + tltype).html(tuluyen_arr['tl_point_next']);
                        $("#tl_money_" + tltype).html(tuluyen_arr['tl_vip_money_price']);
                        switch (tltype) {
                            case 'str':
                                var tuluyen_name = 'Sức Mạnh';
                                break;
                            case 'agi':
                                var tuluyen_name = 'Nhanh Nhẹn';
                                break;
                            case 'vit':
                                var tuluyen_name = 'Thể Lực';
                                break;
                            default:
                                var tuluyen_name = 'Năng Lượng';
                        }
                        var tl_show = '<div class="select-box sl-bx-tl"><select id="tl_select_' + tltype + '" class="tl_select" tltype="' + tltype + '">';
                        for ($i = 1; $i <= 20; $i++) tl_show += "<option value='" + $i * 5 + "'>" + $i * 5 + " Exp</option>";
                        tl_show += '</select></div>';
                        tl_show += '<div class="group-popup">';
                        tl_show += '<div class="box-popup box-popup-red" data-popup="popup-click-' + tltype + '"></div>';
                        tl_show += '<input data-showpopup="' + tltype + '" type="button" value="' + tuluyen_name + '" class="tuluyen btn btn-green btn-block btn-lg" id="btn_tl_' + tltype + '" tltype="' + tltype + '" />';
                        tl_show += '</div>';
                        $("#btn_tl" + tltype).html(tl_show);
                        $("#progress_bar_" + tltype).width(tuluyen_arr['tl_percent_new'] + "%");
                        $("#btn_tl_random").removeAttr('disabled'); /* $("#tlsuccess").html("<div class='color-green'>"+ tuluyen_arr['msg'] +"</div>"); */
                        var ss_html = "<div class='color-green'>" + tuluyen_arr['msg'] + "</div>";
                        $(".box-popup").removeClass('show box-popup-green box-popup-red');
                        var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                        $(classShow).addClass('show box-popup-green').html(ss_html);
                    } else {
                        $("#btn_tl_random").attr('disabled', 'disabled');
                        $("#tlcp_" + tltype).html(tuluyen_arr['tlcp']); /* $("#tlerror").html("<div class='color-primary'>"+ tuluyen_arr['msg'] +"</div>"); */
                        var ss_html = "<div class='color-primary'>" + tuluyen_arr['msg'] + "</div>";
                        $(".box-popup").removeClass('show box-popup-green box-popup-red');
                        var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                        $(classShow).addClass('show box-popup-green').html(ss_html);
                    }
                } else {
                    /* $("#tlerror").html("<div class='color-primary'>"+ html +"</div>"); */
                    var ss_html = "<div class='color-primary'>" + html + "</div>";
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-green').html(ss_html);
                }
            }
        });
        return false;
    });
    $('body').on('click', ".btn_phucloi", function() {
        var qindex = $(this).attr("qindex");
        var inptab = $(this).attr("inptab");
        var dataString = "action=nhanthuong&qindex=" + qindex;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=questdaily",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_quest_" + qindex).html("<img src='images/loading1.gif' border='0' />");
                $("#qsuccess").html("");
                $("#qerror").html("");
                $("#btn_quest_" + qindex).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_quest_" + qindex).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#head_gcoin").html(html_split[5]);
                    $("#head_gcoin_km").html(html_split[6]);
                    $("#head_vpoint").html(html_split[7]);
                    $("#head_vpoint_km").html(html_split[8]);
                    $("#head_wcoin").html(html_split[9]);
                    $("#head_pp").html(html_split[10]);
                    $("#head_pp_extra").html(html_split[11]);
                    if (html_split[2] == 0) {
                        $("#qdl_un").removeClass().html('');
                        $("#char_note").removeClass();
                        $("#nvhn_tab1").removeClass().html('');
                        $("#nvhn_tab2").removeClass().html('');
                        $("#nvhn_tab3").removeClass().html('');
                        $("#nvhn_tab4").removeClass().html('');
                        $(".btn_phucloi_stat").html('Đã hết số phần thưởng có thể nhận.');
                    } else {
                        $("#qdl_un").removeClass().addClass('badge').html(html_split[2]);
                        $("#char_note").removeClass().addClass('note-evt');
                        if (inptab == 1) {
                            var nvhn_tab_read = $("#nvhn_tab1").html();
                            var nvhn_tab_redure = parseInt(nvhn_tab_read) - 1;
                            $("#nvhn_tab1").removeClass().addClass('badge').html(nvhn_tab_redure);
                        } else if (inptab == 2) {
                            var nvhn_tab_read = $("#nvhn_tab2").html();
                            var nvhn_tab_redure = parseInt(nvhn_tab_read) - 1;
                            $("#nvhn_tab2").removeClass().addClass('badge').html(nvhn_tab_redure);
                        } else if (inptab == 3) {
                            var nvhn_tab_read = $("#nvhn_tab3").html();
                            var nvhn_tab_redure = parseInt(nvhn_tab_read) - 1;
                            $("#nvhn_tab3").removeClass().addClass('badge').html(nvhn_tab_redure);
                        } else if (inptab == 4) {
                            var nvhn_tab_read = $("#nvhn_tab4").html();
                            var nvhn_tab_redure = parseInt(nvhn_tab_read) - 1;
                            $("#nvhn_tab4").removeClass().addClass('badge').html(nvhn_tab_redure);
                        }
                    }
                    $("#nvhn_finish").html(html_split[3]);
                    $("#btn_spanquest_" + qindex).html("<span class='tag tag-blue'>Đã nhận</span>");
                    _showPopup('Nhận thưởng nhiệm vụ', '<span class=\'color-green\'>' + html_split[4] + '</span>');
                } else {
                    $("#btn_quest_" + qindex).removeAttr('disabled');
                    _showPopup('Lỗi', '<span class=\'color-red\'>' + html + '</span>');
                }
            }
        });
        return false;
    });
    $('body').on('click', "#btn_pl_change", function() {
        var pl_point_change = $('#pl_point_change').val();
        if (!pl_point_change) pl_point_change = 0;
        pl_point_change = parseInt(pl_point_change);
        var pl_point_to = $('#pl_point_to').val();
        if (pl_point_change == 0) {
            $("#plchange_error").html("<div class='color-primary'>Điểm Phúc Lợi muốn đổi phải lớn hơn 0.</div>");
        } else {
            var dataString = "action=plchange&pl_point_to=" + pl_point_to + "&pl_point_change=" + pl_point_change;
            $.ajax({
                type: "GET",
                url: "ajax_action.php?ajax=questdaily",
                data: dataString,
                cache: false,
                beforeSend: function() {
                    $("#loading_pl_change").html("<img src='images/loading1.gif' border='0' />");
                    $("#plchange_success").html("");
                    $("#plchange_error").html("");
                    $("#btn_pl_change").attr('disabled', 'disabled');
                },
                complete: function() {
                    $("#loading_pl_change").html("");
                },
                success: function(html) {
                    var html_split = html.split("|");
                    if (html_split[1] == "OK") {
                        $("#pl_point").html(html_split[2]);
                        $("#plchange_success").html("<div class='color-green'>" + html_split[3] + "</div>");
                    } else {
                        $("#plchange_error").html("<div class='color-primary'>" + html + "</div>");
                    }
                    $("#btn_pl_change").removeAttr('disabled');
                }
            });
        }
        return false;
    });
    $('body').on('click', "#btn_st_up", function() {
        var dataString = "action=update";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=songtu",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_st").html("<img src='images/loading1.gif' border='0' />");
                $("#stsuccess").html("");
                $("#sterror").html("");
                $("#btn_st_up").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_st").html("");
                $("#btn_st_up").removeAttr('disabled');
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    var songtu_arr = $.parseJSON(html_split[2]);
                    $("#st_point").html(songtu_arr['stpoint']);
                    if (songtu_arr['tangcap'] == 1) {
                        $("#stexp").html('<font color="blue">' + songtu_arr['exp'] + '</font>');
                        $("#btn_st").html('<input type="button" value="Thăng Cấp Song Tu" class="st_thangcap" id="btn_st_tc" /><br /><strong><font color="red">Chúc Phúc : <span id="stcp">0</span> %</font></strong>');
                    } else {
                        $("#stexp").html(songtu_arr['exp']).slideDown('slow');
                    }
                    $("#stsuccess").html("<div class='color-green'>Song Tu thành công<br />Độ Thân Mật tăng lên <strong>" + songtu_arr['exp'] + "</strong></div>");
                } else {
                    $("#sterror").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', "#btn_st_tc", function() {
        var dataString = "action=thangcap";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=songtu",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_st").html("<img src='images/loading1.gif' border='0' />");
                $("#stsuccess").html("");
                $("#sterror").html("");
                $("#btn_st_tc").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_st").html("");
                $("#btn_st_tc").removeAttr('disabled');
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    var tuluyen_arr = $.parseJSON(html_split[2]);
                    $("#tl_point").html(tuluyen_arr['tlpoint']);
                    if (tuluyen_arr['tangcap'] == 1) {
                        $("#stlv").html(tuluyen_arr['songtu_lv']);
                        $("#stexpup").html(tuluyen_arr['songtu_exp_next']);
                        $("#st_percent_point").html(tuluyen_arr['songtu_point_percent']);
                        $("#btn_st").html('<input type="button" value="Song Tu" class="songtu" id="btn_st_up" />');
                        $("#stsuccess").html("<div class='color-green'>" + tuluyen_arr['msg'] + "</div>");
                    } else {
                        $("#stcp").html(tuluyen_arr['cp_percent']);
                        $("#sterror").html("<div class='color-primary'>" + tuluyen_arr['msg'] + "</div>");
                    }
                } else {
                    $("#sterror").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', "#btn_gift_st_point", function() {
        var gift_stpoint = $('#gift_st_point').val();
        if (!gift_stpoint) gift_stpoint = 0;
        gift_stpoint = parseInt(gift_stpoint);
        if (gift_stpoint <= 0) {
            $("#gift_st_notice").html("<div class='color-primary'>Điểm Song Tu muốn tặng phải lớn hơn 0.</div>");
        } else {
            var dataString = "action=gift_stpoint&gift_stpoint=" + gift_stpoint;
            $.ajax({
                type: "GET",
                url: "ajax_action.php?ajax=songtu",
                data: dataString,
                cache: false,
                beforeSend: function() {
                    $("#gift_stpoint_loading").html("<img src='images/loading1.gif' border='0' />");
                    $("#gift_st_notice").html("");
                    $("#btn_gift_st_point").attr('disabled', 'disabled');
                },
                complete: function() {
                    $("#gift_stpoint_loading").html("");
                    $("#btn_gift_st_point").removeAttr('disabled');
                },
                success: function(html) {
                    var html_split = html.split("|");
                    if (html_split[1] == "OK") {
                        var gift_arr = $.parseJSON(html_split[2]);
                        $("#st_point").html(gift_arr['songtu_point']);
                        $("#gift_st_notice").html("<div class='color-green'>Đã tặng bạn đời " + gift_stpoint + " Điểm Tu Luyện.<br />Chi phí : 1 Trái Tim.<br />Bạn còn : " + gift_arr['heart'] + " Trái Tim.</div>");
                        $('#gift_st_point').val(0);
                    } else {
                        $("#gift_st_notice").html("<div class='color-primary'>" + html + "</div>");
                    }
                }
            });
        }
        return false;
    });
    $('body').on('click', ".item_ch_open", function() {
        var vitri = $(this).attr('vitri');
        $("#itemch_unactive_" + vitri).slideUp();
        $("#itemch_active_" + vitri).slideDown();
        return false;
    });
    $('body').on('click', ".item_ch_close", function() {
        var vitri = $(this).attr('vitri');
        $("#itemch_unactive_" + vitri).slideDown();
        $("#itemch_active_" + vitri).slideUp();
        $('#item_ch_open_' + vitri).show();
        return false;
    });
    $('body').on('click', ".chitem", function() {
        var vitri = $(this).attr("vitri");
        var serial = $(this).attr("serial");
        var item_lvl = $(this).attr("item_lvl");
        var dataString = "vitri=" + vitri + "&serial=" + serial + "&item_lvl=" + item_lvl;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=cuonghoa",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#itemch_loading_" + vitri).html("<img src='images/loading1.gif' border='0' />");
                $("#itemch_view_" + vitri).html("");
                $("#chitem_" + vitri).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#itemch_loading_" + vitri).html("");
                $("#chitem_" + vitri).removeAttr('disabled');
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    var chup_arr = $.parseJSON(html_split[2]);
                    $("#itemch_cp_" + vitri).html(chup_arr['cp_percent']);
                    $("#chpoint").html(chup_arr['cuonghoa_point_new']);
                    if (chup_arr['uplv'] == 0) {
                        $("#itemch_view_" + vitri).html("<div class='color-primary'>" + chup_arr['msg'] + "</div>");
                    } else {
                        $("#itemch_view_" + vitri).html("<div class='color-green'>" + chup_arr['msg'] + "</div>");
                        $("#itemlv_now_" + vitri).html(chup_arr['itemlvl_new']);
                        $("#itemlv_up_" + vitri).html(chup_arr['itemlvl_new'] + 1);
                    }
                } else {
                    $("#itemch_view_" + vitri).html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', ".item_hh_open", function() {
        var vitri = $(this).attr('vitri');
        $("#itemhh_unactive_" + vitri).slideUp();
        $("#itemhh_active_" + vitri).slideDown();
        return false;
    });
    $('body').on('click', ".item_hh_close", function() {
        var vitri = $(this).attr('vitri');
        $("#itemhh_unactive_" + vitri).slideDown();
        $("#itemhh_active_" + vitri).slideUp();
        $('#item_hh_open_' + vitri).show();
        return false;
    });
    $('body').on('click', ".hhitem", function() {
        var vitri = $(this).attr("vitri");
        var serial = $(this).attr("serial");
        var dataString = "vitri=" + vitri + "&serial=" + serial;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=hoanhaohoa",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#itemhh_loading_" + vitri).html("<img src='images/loading1.gif' border='0' />");
                $("#itemhh_view_" + vitri).html("");
                $("#hhitem_" + vitri).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#itemhh_loading_" + vitri).html("");
                $("#hhitem_" + vitri).removeAttr('disabled');
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    var hhup_arr = $.parseJSON(html_split[2]);
                    $("#itemhh_cp_" + vitri).html(hhup_arr['cp_percent']);
                    $("#hhpoint").html(hhup_arr['hh_point_new']);
                    if (hhup_arr['up'] == 0) {
                        $("#itemhh_view_" + vitri).html("<div class='color-primary'>" + hhup_arr['msg'] + "</div>");
                    } else {
                        $("#itemhh_view_" + vitri).html("<div class='color-green'>" + hhup_arr['msg'] + "</div>");
                        $("#itemhh_now_" + vitri).html(hhup_arr['exc_total_new']);
                        $("#itemhh_up_" + vitri).html(hhup_arr['exc_total_new'] + 1);
                    }
                } else {
                    $("#itemhh_view_" + vitri).html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', "#btn_pl_ban", function() {
        var plpoint_ban = $("#plpoint_ban").val();
        var plpoint_vpoint = $("#plpoint_vpoint").val();
        var dataString = "action=banpl&plpoint_ban=" + plpoint_ban + "&plpoint_vpoint=" + plpoint_vpoint;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=chopl",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#banpl_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#banpl_view").html("");
                $("#btn_pl_ban").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#banpl_loading").html("");
                $("#btn_pl_ban").removeAttr('disabled');
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#plpoint").html(html_split[2]);
                    $("#banpl_view").html("<div class='color-green'>" + html_split[3] + "</div>");
                    $("#plpoint_ban").val(0);
                    $("#plpoint_vpoint").val(0);
                } else {
                    $("#banpl_view").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', ".btn_plmua", function() {
        var store_id = $(this).attr("store_id");
        var dataString = "action=muapl&store_id=" + store_id;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=chopl",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#muapl_view_" + store_id).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_plmua_" + store_id).attr('disabled', 'disabled');
            },
            complete: function() {},
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#muapl_view_" + store_id).html("<div class='color-green'>" + html_split[2] + "</div>");
                    $("#btn_plmua_" + store_id).val("Đã mua");
                } else {
                    $("#muapl_view_" + store_id).html("<div class='color-primary'>" + html + "</div>");
                    $("#btn_plmua_" + store_id).removeAttr('disabled');
                }
            }
        });
        return false;
    });
    $('body').on('click', ".btn_huyban", function() {
        var store_id = $(this).attr("store_id");
        var dataString = "action=huyban&store_id=" + store_id;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=chopl",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#huypl_view_" + store_id).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_huyban_" + store_id).attr('disabled', 'disabled');
            },
            complete: function() {},
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#huypl_view_" + store_id).html("<div class='color-green'>" + html_split[2] + "</div>");
                    $("#plpoint").html(html_split[3]);
                    $("#td_huyban_" + store_id).html("Đã hủy");
                } else {
                    $("#huypl_view_" + store_id).html("<div class='color-primary'>" + html + "</div>");
                    $("#btn_huyban_" + store_id).removeAttr('disabled');
                }
            }
        });
        return false;
    });
    $('body').on('click', ".itemreward_up", function() {
        var vitri = $(this).attr('vitri');
        $("#itemreward_unactive_" + vitri).slideUp();
        $("#itemreward_active_" + vitri).slideDown();
        return false;
    });
    $('body').on('click', ".itemreward_down", function() {
        var vitri = $(this).attr('vitri');
        $("#itemreward_unactive_" + vitri).slideDown();
        $("#itemreward_active_" + vitri).slideUp();
        return false;
    });

    function func_rewarditem(vitri) {
        var reward_type = $('#reward_type').val();
        var lvl = $('#level_' + vitri).val();
        var opt = $('#option_' + vitri).val();
        var rewardday = $('#rewardday_' + vitri).val();
        var luck = 0;
        if ($('#luck_' + vitri).is(":checked")) {
            var luck = 1;
        }
        var exl1 = 0;
        if ($('#exl_' + vitri + '_1').is(":checked")) {
            var exl1 = 1;
        }
        var exl2 = 0;
        if ($('#exl_' + vitri + '_2').is(":checked")) {
            var exl2 = 1;
        }
        var exl3 = 0;
        if ($('#exl_' + vitri + '_3').is(":checked")) {
            var exl3 = 1;
        }
        var exl4 = 0;
        if ($('#exl_' + vitri + '_4').is(":checked")) {
            var exl4 = 1;
        }
        var exl5 = 0;
        if ($('#exl_' + vitri + '_5').is(":checked")) {
            var exl5 = 1;
        }
        var exl6 = 0;
        if ($('#exl_' + vitri + '_6').is(":checked")) {
            var exl6 = 1;
        }
        var dataString = "action=rewardprice&reward_type=" + reward_type + "&vitri=" + vitri + "&luck=" + luck + "&exl1=" + exl1 + "&exl2=" + exl2 + "&exl3=" + exl3 + "&exl4=" + exl4 + "&exl5=" + exl5 + "&exl6=" + exl6 + "&lvl=" + lvl + "&opt=" + opt + "&rewardday=" + rewardday;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=rewarditem",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#btn_reward_waiting_" + vitri).html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {
                $("#btn_reward_waiting_" + vitri).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#notice_reward_info_" + vitri).html("<div class='color-green'>" + html_split[2] + "</div>");
                    $("#head_gcoin").html(html_split[3]);
                    $("#head_gcoin_km").html(html_split[4]);
                } else {
                    $("#notice_reward_info_" + vitri).html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    }
    $('body').on('click', '.reward_luck, .reward_exl', function() {
        var vitri = $(this).attr('vitri');
        func_rewarditem(vitri);
    });
    $('body').on('change', '.reward_lvl, .reward_op, .reward_day', function() {
        var vitri = $(this).attr('vitri');
        func_rewarditem(vitri);
    });
    $('body').on('click', '.btn_reward', function() {
        var vitri = $(this).attr('vitri');
        var reward_type = $('#reward_type').val();
        var lvl = $('#level_' + vitri).val();
        var opt = $('#option_' + vitri).val();
        var rewardday = $('#rewardday_' + vitri).val();
        var luck = 0;
        if ($('#luck_' + vitri).is(":checked")) {
            var luck = 1;
        }
        var exl1 = 0;
        if ($('#exl_' + vitri + '_1').is(":checked")) {
            var exl1 = 1;
        }
        var exl2 = 0;
        if ($('#exl_' + vitri + '_2').is(":checked")) {
            var exl2 = 1;
        }
        var exl3 = 0;
        if ($('#exl_' + vitri + '_3').is(":checked")) {
            var exl3 = 1;
        }
        var exl4 = 0;
        if ($('#exl_' + vitri + '_4').is(":checked")) {
            var exl4 = 1;
        }
        var exl5 = 0;
        if ($('#exl_' + vitri + '_5').is(":checked")) {
            var exl5 = 1;
        }
        var exl6 = 0;
        if ($('#exl_' + vitri + '_6').is(":checked")) {
            var exl6 = 1;
        }
        var dataString = "action=rewardsend&reward_type=" + reward_type + "&vitri=" + vitri + "&luck=" + luck + "&exl1=" + exl1 + "&exl2=" + exl2 + "&exl3=" + exl3 + "&exl4=" + exl4 + "&exl5=" + exl5 + "&exl6=" + exl6 + "&lvl=" + lvl + "&opt=" + opt + "&rewardday=" + rewardday;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=rewarditem",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#btn_reward_waiting_" + vitri).html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {
                $("#btn_reward_waiting_" + vitri).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#reward_success_" + vitri).html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#reward_success_" + vitri).html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', '.btn_webshop', function() {
        var vitri = $(this).attr('vitri');
        var webshop_type = $('#webshop_type').val();
        var money_type = $('#money_type_' + vitri).val();
        var webshop_slg = $('#webshop_slg_' + vitri).val();
        var dataString = "action=webshop_send&vitri=" + vitri + "&webshop_type=" + webshop_type + "&money_type=" + money_type + "&slg=" + webshop_slg;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=webshop_item",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#btn_webshop_waiting_" + vitri).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_webshop_" + vitri).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#btn_webshop_waiting_" + vitri).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    _showPopup('Webshop', '<span class=\'color-green\'>' + html_split[2] + '</span>');
                    $("#head_gcoin").html(html_split[3]);
                    $("#head_gcoin_km").html(html_split[4]);
                    $("#head_vpoint").html(html_split[5]);
                    $("#head_vpoint_km").html(html_split[6]);
                } else {
                    _showPopup('Webshop', '<span class=\'color-red\'>' + html + '</span>');
                }
                $("#btn_webshop_" + vitri).removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', '#xoay_longcondor', function() {
        var dataString = "action=xoay_longcondor";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=maychao",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#xoay_longcondor_msg").html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {},
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    if (html_split[2] == 1) {
                        $("#xoay_longcondor_info").html("<div class='color-green'>" + html_split[3] + "</div>");
                        $("#xoay_longcondor_msg").html("");
                    } else if (html_split[2] == 2) {
                        $("#xoay_longcondor_info").html("<div class='color-primary'>" + html_split[3] + "</div>");
                        $("#xoay_longcondor_msg").html("");
                    } else {
                        $("#xoay_longcondor_msg").html("<div class='color-green'>" + html_split[3] + "</div>");
                    }
                } else {
                    $("#xoay_longcondor_msg").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', '#trader_quay', function() {
        var item = $(this).attr('item');
        var tyle = $(this).attr('tyle');
        var dataString = "action=trader_quay&item=" + item + "&tyle=" + tyle;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=maychao",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#trader_quay_msg").html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {},
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    if (html_split[2] == 1) {
                        $("#trader_quay_info").html("<div class='color-green'>" + html_split[3] + "</div>");
                        $("#trader_quay_msg").html("");
                    } else if (html_split[2] == 2) {
                        $("#trader_quay_info").html("<div class='color-primary'>" + html_split[3] + "</div>");
                        $("#trader_quay_msg").html("");
                    } else {
                        $("#trader_quay_msg").html("<div class='color-green'>" + html_split[3] + "</div>");
                    }
                } else {
                    $("#trader_quay_msg").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', '#kickket', function() {
        var opd = $('#opd').val();
        var dataString = "opd=" + opd;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=kickket",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#kickket_msg").html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {},
            success: function(html) {
                if (html == 'OK') {
                    $("#kickket_msg").html("<div class='color-green'>Đã gửi thông tin Kích Kẹt. Bạn vui lòng đợi trong 5 giây rồi vào Game.</div>");
                } else {
                    $("#kickket_msg").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', 'input[name=money_type]', function() {
        var money_type = $('input[name=money_type]:checked').val();
        $.get("ajax_action.php", {
            ajax: "relax_lo",
            action: 'change_money',
            imoney_type: money_type
        }, function(data) {
            $("#lo_diem").html(data);
        });
        $("#diemlo_money").html("0");
    });
    $('body').on('change', "#lo_diem", function() {
        var lo_diem = $("#lo_diem").val();
        var money_type = $('input[name=money_type]:checked').val();
        $.get("ajax_action.php", {
            ajax: "relax_lo",
            ilo_diem: lo_diem,
            imoney_type: money_type
        }, function(data) {
            $("#diemlo_money").html(data);
        });
    });
    $('body').on('click', '#relax_lo_danh', function() {
        var lo_so = $('#lo_so').val();
        var lo_diem = $('#lo_diem').val();
        var money_type = $('input[name=money_type]:checked').val();
        var dataString = "action=danhlo&lo_so=" + lo_so + "&lo_diem=" + lo_diem + "&money_type=" + money_type;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=relax_lo",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#lo_msg").html("<img src='images/loading1.gif' border='0' />");
                $("#relax_lo_danh").removeClass().addClass("NotAccept").attr('disabled', 'disabled');
            },
            complete: function() {},
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == 'OK') {
                    $("#lo_msg").html("<div class='color-green'>Đã đánh " + lo_diem + " điểm lô con " + lo_so + ".<br />Chúc bạn may mắn.</div>");
                    if (money_type == 2) {
                        $("#lo_vpoint").html(html_split[2]);
                        $("#head_vpoint").html(html_split[2]);
                    } else {
                        $("#lo_gcoin").html(html_split[2]);
                        $("#head_gcoin").html(html_split[2]);
                    }
                    $("#lo_so").val(0);
                    $("#lo_diem").val(0);
                    $("#diemlo_money").html("0");
                } else {
                    $("#lo_msg").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#relax_lo_danh").removeClass().addClass("Accept").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', '#btn_lo_history', function() {
        var dataString = "action=lo_history";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=relax_lo",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#lo_history").html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {},
            success: function(html) {
                $("#lo_history").html("<div class='info_noimg'>" + html + "</div>");
            }
        });
        return false;
    });
    $('body').on('click', 'input[name=money_type_de]', function() {
        var money_type = $('input[name=money_type_de]:checked').val();
        $.get("ajax_action.php", {
            ajax: "relax_de",
            action: 'change_money',
            imoney_type: money_type
        }, function(data) {
            $("#de_diem").html(data);
        });
    });
    $('body').on('click', '#relax_de_danh', function() {
        var de_so = $('#de_so').val();
        var de_diem = $('#de_diem').val();
        var money_type = $('input[name=money_type_de]:checked').val();
        var dataString = "action=danhde&de_so=" + de_so + "&de_diem=" + de_diem + "&money_type=" + money_type;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=relax_de",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#de_msg").html("<img src='images/loading1.gif' border='0' />");
                $("#relax_de_danh").removeClass().addClass("NotAccept").attr('disabled', 'disabled');
            },
            complete: function() {},
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == 'OK') {
                    if (money_type == 2) {
                        var money_name = "Vcent";
                        $("#de_vpoint").html(html_split[2]);
                        $("#head_vpoint").html(html_split[2]);
                    } else {
                        var money_name = "Gcent";
                        $("#de_gcoin").html(html_split[2]);
                        $("#head_gcoin").html(html_split[2]);
                    }
                    $("#de_msg").html("<div class='color-green'>Đã đánh " + de_diem + ".000 " + money_name + " đề con " + de_so + ".<br />Chúc bạn may mắn.</div>");
                    $("#de_so").val(0);
                    $("#de_diem").val(0);
                } else {
                    $("#de_msg").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#relax_de_danh").removeClass().addClass("Accept").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', '#btn_de_history', function() {
        var dataString = "action=de_history";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=relax_de",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#de_history").html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {},
            success: function(html) {
                $("#de_history").html("<div class='info_noimg'>" + html + "</div>");
            }
        });
        return false;
    });
    $('body').on('click', '.danhhieu_choise', function() {
        var danhhieu_type = $(this).attr("danhhieu_type");
        var danhhieu_id = $(this).attr("danhhieu_id");
        var dataString = "action=danhhieu_choise&danhhieu_type=" + danhhieu_type + "&danhhieu_id=" + danhhieu_id;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=char_danhhieu",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#msg_" + danhhieu_type + "_" + danhhieu_id).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_" + danhhieu_type + "_" + danhhieu_id).attr('disabled', 'disabled');
            },
            complete: function() {},
            success: function(html) {
                if (html == 'OK') {
                    $("#msg_" + danhhieu_type + "_" + danhhieu_id).html("");
                    $("#danhhieu_col_" + danhhieu_type + "_" + danhhieu_id).html("<strong class='color-primary'>Đã kích hoạt.<br />Hãy đổi nhân vật trong Game để có hiệu lực.</strong>");
                } else {
                    $("#msg_" + danhhieu_type + "_" + danhhieu_id).html("Lỗi : " + html);
                    $("#btn_" + danhhieu_type + "_" + danhhieu_id).removeAttr('disabled');
                }
            }
        });
        return false;
    });
    $('body').on('click', '.event2_doi', function() {
        var event_type = $(this).attr('event_type');
        var phuongthuc = $(this).attr('phuongthuc');
        var dataString = "action=event2_doi&event_type=" + event_type + "&phuongthuc=" + phuongthuc;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=event2",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_btn_event2_doi_" + event_type + "_" + phuongthuc).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_event2_doi_" + event_type + "_" + phuongthuc).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_btn_event2_doi_" + event_type + "_" + phuongthuc).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == 'OK') {
                    var item_source_data = html_split[3];
                    var item_source_arr = $.parseJSON(item_source_data);
                    for ($i = 0; $i <= 3; $i++) {
                        $(".item_source_" + $i + "_slg").html(item_source_arr[$i]['slg_api']);
                        if (item_source_arr[$i]['slg_api'] == 0) {
                            if ($i == 1) {
                                $(".event2_doi").attr('disabled', 'disabled');
                            }
                            if ($i == 2) {
                                $(".event2_doi[phuongthuc='2']").attr('disabled', 'disabled');
                                $(".event2_doi[phuongthuc='3']").attr('disabled', 'disabled');
                            }
                            if ($i == 3) {
                                $(".event2_doi[phuongthuc='3']").attr('disabled', 'disabled');
                            }
                            $(".item_source_" + $i).addClass('disabled');
                        }
                    }
                    switch (event_type) {
                        case 'type1':
                            var zen_update = html_split[4];
                            $(".event2_zen").html(zen_update);
                            break;
                        case 'type3':
                            break;
                    }
                    if (html_split[7] != '') {
                        var gcoin_update = html_split[5];
                        var gcoin_km_update = html_split[6];
                        var gcoin_total = html_split[7];
                        $("#head_gcoin").html(gcoin_update);
                        $("#head_gcoin_km").html(gcoin_km_update);
                        $(".event2_gc").html(gcoin_total);
                    }
                    $("#head_vpoint_km").html(html_split[8]);
                    $("#head_wcoin").html(html_split[9]);
                    $("#head_pp").html(html_split[10]);
                    $("#head_pp_extra").html(html_split[11]);
                    var dadoi_count = html_split[12];
                    var dadoi_count_arr = $.parseJSON(dadoi_count);
                    if (dadoi_count_arr['tylemax'][event_type] > 0) {
                        $("#tab_event2_" + event_type).html(dadoi_count_arr['tylemax'][event_type]);
                    } else {
                        $("#tab_event2_" + event_type).removeClass().html('');
                        $(".btn_event2_doi_" + event_type).attr('disabled', 'disabled');
                    }
                    $("#event2_dadoi_all_" + event_type).html(dadoi_count_arr['all'][event_type]);
                    $("#event2_dadoi_daily_all_" + event_type).html(dadoi_count_arr['daily'][event_type]['all']);
                    $("#event2_dadoi_daily_" + phuongthuc + "_" + event_type).html(dadoi_count_arr['daily'][event_type][phuongthuc]);
                    _showPopup('Thông tin đổi Event', '<span class=\'color-green\'>' + html_split[2] + '</span>');
                } else if (html_split[1] == 'Err') {
                    if (html_split[2] == 0) {
                        _showPopup('Lỗi', '<span class=\'color-red\'>' + html_split[3] + '</span>');
                    }
                } else {
                    _showPopup('Lỗi', '<span class=\'color-red\'>' + html + '</span>');
                    $("#btn_event2_doi_" + event_type + "_" + phuongthuc).removeAttr('disabled');
                }
            }
        });
        return false;
    });
    $('body').on('click', ".gift_thangcap", function() {
        var gift_rs = $(this).attr("gift_rs");
        var popupShow = $(this).data('showpopup');
        var dataString = "action=nhanthuong&gift_rs=" + gift_rs;
        console.log(dataString)
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=event_gift_thangcap",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_" + gift_rs).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_giftthangcap_" + gift_rs).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_" + gift_rs).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#btn_giftthangcap_" + gift_rs).prop({
                        disabled: true
                    }).text('Đã nhận'); /* var tuluyen_arr = $.parseJSON(html_split[2]); */
                    var ss_html = "<div class='color-green'>" + html_split[2] + "</div>";
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-green').html(ss_html);
                } else {
                    $("#btn_giftthangcap_" + gift_rs).removeAttr('disabled');
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-red').html(html);
                }
            }
        });
        return false;
    });
    $('body').on('click', ".warehouse_move", function() {
        var $wh_target = $(this);
        var warehouse_type = $(this).attr("warehouse_type"); /* 0 : WareHouse | 1 : WareHouse Secure */
        var itemcode = $(this).attr("itemcode"); /* itemcode : Code Item */
        var key = $(this).attr("key");
        if (warehouse_type == 0) {
            var time_gui = 0;
        } else {
            var time_gui = $(this).attr("time_gui");
        }
        var dataString = "action=warehouse_move&warehouse_type=" + warehouse_type + "&itemcode=" + itemcode + "&time_gui=" + time_gui;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=warehouse_secure",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $wh_target.addClass('moving');
                $(".warehouse_move").removeClass("warehouse_move").addClass("warehouse_moving");
                $("#" + itemcode + key).html("<img src='images/loading1.gif' border='0' />");
            },
            complete: function() {
                $("#" + itemcode + key).html("");
            },
            success: function(html) {
                $wh_target.removeClass('moving');
                $(".warehouse_moving").removeClass("warehouse_moving").addClass("warehouse_move");
                var html_split = html.split("|");
                if (html_split[1] == "OK") {                    
                    if (warehouse_type == '0') {
                        $(".warehouse_move[itemcode=" + itemcode + "][key=" + key + "]").attr({
                            warehouse_type: '1',
                            time_gui: html_split[2]
                        });
                        $(".warehouse_move[itemcode=" + itemcode + "][key=" + key + "]").appendTo("#warehouse_secure_list");
                        $("#item_in_warehouse_secure").html(html_split[3]);
                        $("#menu_warehouse_secure_item").html(html_split[3]);
                        if (html_split[4] == '0') {
                            $("#acc_note").removeClass();
                        } else {
                            $("#acc_note").addClass("note-evt");
                        }
                    } else {
                        $(".warehouse_move[itemcode=" + itemcode + "][key=" + key + "]").attr("warehouse_type", '0');
                        $(".warehouse_move[itemcode=" + itemcode + "][key=" + key + "]").appendTo("#warehouse_list");
                        $("#item_in_warehouse_secure").html(html_split[2]);
                        $("#menu_warehouse_secure_item").html(html_split[2]);
                        if (html_split[3] == '0') {
                            $("#acc_note").removeClass();
                        } else {
                            $("#acc_note").addClass("note-evt");
                        }
                    }
                } else {
                    _showPopup('Rương Đồ An toàn', '<span class=\'color-primary\'>' + html + '</span>');
                }
            }
        });
        return false;
    });
    $('body').on('click', "#btn_upgradevip", function() {
        var pass2 = $('input[name=pass2]').val();
        var vip_type = $('select[name=type] option:selected').val();
        var vip_plan = $('select[name=plan] option:selected').val();
        var dataString = "action=upgrade_vip&pass2=" + pass2 + "&type=" + vip_type + "&plan=" + vip_plan;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=vip_system",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#uv_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#uv_err").html("");
                $("#btn_upgradevip").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#uv_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#uv_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#uv_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_upgradevip").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "#btn_vip_receivepl", function() {
        var dataString = "action=receivepl";
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=vip_system",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#uv_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#uv_content").html("");
                $("#btn_vip_receivepl").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#uv_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#uv_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#uv_content").html("<div class='color-primary'>" + html + "</div>");
                    $("#btn_vip_receivepl").removeAttr('disabled');
                }
            }
        });
        return false;
    });
    $('body').on('click', "#btn_enableip", function() {
        var opd = $('input[name=opd]').val();
        var tfa = $('input[name=tfa]').val();
        var dataString = "action=enable_ip&opd=" + opd + "&tfa=" + tfa;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=ip_protect",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#uv_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#uv_err").html("");
                $("#btn_enableip").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#uv_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#uv_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#uv_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_enableip").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "#btn_addip", function() {
        var opd = $('input[name=opd]').val();
        var tfa = $('input[name=tfa]').val();
        var ip = $('input[name=ip_add]').val();
        var dataString = "action=add_ip&opd=" + opd + "&tfa=" + tfa + "&ip=" + ip;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=ip_protect",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#uv_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#uv_err").html("");
                $("#btn_addip").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#uv_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#uv_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#uv_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_addip").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "#btn_removeip", function() {
        var opd = $('input[name=opd]').val();
        var tfa = $('input[name=tfa]').val();
        var ip = $('input[name=ip_remove]:checked').val();
        var dataString = "action=remove_ip&opd=" + opd + "&tfa=" + tfa + "&ip=" + ip;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=ip_protect",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#uv_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#uv_err").html("");
                $("#btn_removeip").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#uv_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#uv_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#uv_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_removeip").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', ".vip ul li", function() {
        $("li.active").removeClass("active");
        $(this).addClass('active');
        var plan = $(this).attr('id');
        if (plan == 'day') {
            $(".plan_7").hide();
            $(".plan_30").hide();
        } else if (plan == 'week') {
            $(".plan_7").show();
            $(".plan_30").hide();
        } else if (plan == 'month') {
            $(".plan_30").show();
        }
    });
    $('body').on('click', ".ip_protect_tabs a", function() {
        $(".ip_protect_tabs a").removeClass("active");
        $(this).addClass('active');
        var ip_action = $(this).data('tab');
        if (ip_action == 'enableip') {
            $(".enableip").show();
            $(".addip").hide();
            $(".removeip").hide();
            $(".logip").hide();
        } else if (ip_action == 'addip') {
            $(".enableip").hide();
            $(".addip").show();
            $(".removeip").hide();
            $(".logip").hide();;
        } else if (ip_action == 'removeip') {
            ;
            $(".enableip").hide();
            $(".addip").hide();
            $(".removeip").show();
            $(".logip").hide();
        } else if (ip_action == 'logip') {
            $(".enableip").hide();
            $(".addip").hide();
            $(".removeip").hide();
            $(".logip").show();
        }
    });
    $('body').on('click', "#btn_enable2fa", function() {
        var tfa = $('input[name=tfa]').val();
        var pass2 = $('input[name=pass2]').val();
        var dataString = "action=enable_2fa&tfa=" + tfa + "&pass2=" + pass2;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=2fa",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#uv_loading").html("<img src='images/loading1.gif' border='0' />");
                $("#uv_err").html("");
                $("#btn_enable2fa").attr('disabled', 'disabled');
            },
            complete: function() {
                $("#uv_loading").html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#uv_content").html("<div class='color-green'>" + html_split[2] + "</div>");
                } else {
                    $("#uv_err").html("<div class='color-primary'>" + html + "</div>");
                }
                $("#btn_enable2fa").removeAttr('disabled');
            }
        });
        return false;
    });
    $('body').on('click', "input[name=verify]", function() {
        var verify = $(this).val();
        if (verify == 1) {
            $(".opd").show();
            $(".tfa").hide();
        } else {
            $(".opd").hide();
            $(".tfa").show();
        }
    });
    $('body').on('click', ".gift_firstchange", function() {
        var gift_rs = $(this).attr("gift_rs");
        var idshow = $(this).attr("idshow") + 1;
        var popupShow = $(this).data('showpopup');
        var dataString = "action=nhanthuong&gift_rs=" + gift_rs;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=event_gift_firstchange",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_" + gift_rs).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_giftthangcap_" + gift_rs).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_" + gift_rs).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#btn_giftthangcap_" + gift_rs).prop('value', 'Đã nhận');
                    var ss_html = "<div class='color-green'>" + html_split[2] + "</div>";
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-green').html(ss_html);
                    setTimeout(function() {
                        window.location.href = 'index.php#event&act=FirstCharge&' + (new Date).getTime();
                    }, 3000);
                } else {
                    $("#btn_giftthangcap_" + gift_rs).removeAttr('disabled');
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-red').html(html);
                }
            }
        });
        return false;
    });
    $('body').on('click', '#deloptionexl', function() {
        var item = $(this).attr("item");
        var typeitem = $(this).attr("typeitem");
        var opdel = $('#opdel:checked').val();
        var dataString = "item=" + item + "&opdel=" + opdel + "&typeitem=" + typeitem;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=decreaseopexl",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#trader_quay_msg").html("<img src='images/loading1.gif' border='0' />");
                $("#deloptionexl").attr('disabled', 'disabled');
            },
            complete: function() {},
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    if (html_split[2] == 1) {
                        $("#trader_quay_info").html("<div class='color-green'>" + html_split[3] + "</div>");
                        $("#trader_quay_msg").html("");
                    } else if (html_split[2] == 2) {
                        $("#trader_quay_info").html("<div class='color-primary'>" + html_split[3] + "</div>");
                        $("#trader_quay_msg").html("");
                    } else {
                        $("#trader_quay_msg").html("<div class='color-green'>" + html_split[3] + "</div>");
                    }
                } else {
                    $("#trader_quay_msg").html("<div class='color-primary'>" + html + "</div>");
                }
            }
        });
        return false;
    });
    $('body').on('click', ".gift_thangcapvv", function() {
        var gift_rs = $(this).attr("gift_rs");
        var popupShow = $(this).data('showpopup');
        var dataString = "action=nhanthuong&gift_rs=" + gift_rs;
        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=event_gift_thangcapvv",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_" + gift_rs).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_giftthangcapvv_" + gift_rs).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_" + gift_rs).html("");
            },
            success: function(html) {
                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#btn_giftthangcapvv_" + gift_rs).prop({
                        disabled: true
                    }).text('Đã nhận'); /* var tuluyen_arr = $.parseJSON(html_split[2]); */
                    var ss_html = "<div class='color-green'>" + html_split[2] + "</div>";
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-green').html(ss_html);
                } else {
                    $("#btn_giftthangcapvv_" + gift_rs).removeAttr('disabled');
                    $(".box-popup").removeClass('show box-popup-green box-popup-red');
                    var classShow = ".box-popup[data-popup=popup-click-" + popupShow + "]";
                    $(classShow).addClass('show box-popup-red').html(html);
                }
            }
        });
        return false;
    });
    $('body').on('click', ".btn_payspeed", function() {
        var payid = $(this).attr("payid");

        var dataString = "payid=" + payid;

        $.ajax({
            type: "GET",
            url: "ajax_action.php?ajax=payspeed",
            data: dataString,
            cache: false,
            beforeSend: function() {
                $("#loading_payspeed_" + payid).html("<img src='images/loading1.gif' border='0' />");
                $("#btn_payspeed_" + payid).attr('disabled', 'disabled');
            },
            complete: function() {
                $("#loading_payspeed_" + payid).html("");
            },
            success: function(html) {

                var html_split = html.split("|");
                if (html_split[1] == "OK") {
                    $("#btn_payspeed_" + payid).html("<span class='tag tag-blue'>Đã nhận</span>");
                    _showPopup('Nhận thưởng thành công', '<span class=\'color-green\'>' + html_split[2] + '</span>');

                } else {
                    $("#btn_payspeed_" + payid).removeAttr('disabled');

                    _showPopup('Lỗi', '<span class=\'color-red\'>' + html + '</span>');
                }

            }
        });
        return false;
    });
});



function _showPopup(title, content, callback) {
    if (typeof title == 'undefined') title = 'Thông báo';
    if (typeof content == 'undefined') title = '';
    // $(".popupContent").html(content);
    // $(".popupCaption").html(title);
    // $(".popupCenter, .blackBg").fadeIn('fast', function() {
    //     if (typeof callback == 'function') callback();
    // });
    var toast = $('<div />', {
        class: 'toast show'
    });
    toast.html('<div class="tst"><p>'+content+'</p></div><span class="tstcls">x</span>');
    $('#toasts').toast({text: content});
}



$(document).ready(function() {

    $.fn.toast = function(text){
        console.log(text)
        var msg = $('<div />', {
            class: 'toast show'
        });
        msg.html('<div class="tst"><p>'+text.text+'</p></div><span class="tstcls">x</span>');
        setTimeout(function(){
            msg.removeClass('show');
            setTimeout(function(){
                msg.remove();
            }, 500);
        }, 3000);
        return this.append(msg);
    }

    function _checkHash() {
        var url = window.location.hash;
        if (url.indexOf('#') != -1) {
            var c_url = url.split('#');
            var c_url_last = c_url.length - 1;
            var module = c_url ? c_url[c_url_last] : 'home';
            _pageload('index2.php?mod=' + module, '', 'Main');

            var mod_split = module.split('&');
            var mod_pri = mod_split ? mod_split[0] : module;
            var mod_sec = mod_split ? mod_split[1] : undefined;
            var menuactive = mod_pri;
            var acc_menu = ['#ip_protect','#2fa'];
            if(acc_menu.indexOf(url) > -1)
                menuactive = 'acc_manager'; 
            if(menuactive=='naptien')
                menuactive = 'napthe';           

            $('#category-tabs > ul, #category > li').removeClass('active');
            $('#category-tabs > ul[menu='+menuactive+'], #category > li[menu='+menuactive+']').addClass('active');

            $('#category-tabs > ul li a').removeClass('active');

            $('#category-tabs > ul[menu='+menuactive+'] li').each(function(i, e){      
                var href = $(e).find('a').attr('href');
                if(url == href){
                    $(e).find('a').addClass('active');
                }
            });
        }
        else{
            $('#category-tabs > ul[menu=acc_manager], #category > li[menu=acc_manager]').addClass('active');
        }
    }
    $(window).hashchange(function() {
        _checkHash();
    });
    _checkHash();



    function _initFn() {
        /*$('a, .money_block span, .bank-icon, .item-box, .ui-tooltipster').tooltipster({
            offsetY: 2
        });*/
        $(".table-sort").tablesorter();

        $(".menu-main-tabs .main-tab").click(function() {
            var myIndex = $(this).index();
            $(".menu-main-tabs .main-tab, .content-main-tabs .content-m-tab").removeClass('active');
            $(this).addClass('active');
            $(".content-main-tabs .content-m-tab:eq(" + myIndex + ")").addClass('active');
        });
        $("input[data-showpopup]").hover(function() {
            var popupShow = $(this).data('showpopup');
            $(".box-popup").removeClass('show');
            var classShow = ".box-popup[data-popup=popup-hover-" + popupShow + "]";
            $(classShow).addClass('show');
        }, function() {
            $(".box-popup").removeClass('show');
        });
        $(window).scroll(function() {
            var self = $(this);
            if ($(".stage-menu").length) {
                var activeTab = $(".content-m-tab.active").index();

                if ($(this).scrollTop() >= $(".content-m-tab:eq(" + activeTab + ") .stage-menu").offset().top - 35) {
                    $(".content-m-tab:eq(" + activeTab + ") .stage-menu").addClass('fix');
                } else {
                    $(".content-m-tab:eq(" + activeTab + ") .stage-menu").removeClass('fix');
                }
                $.each($(".content-m-tab:eq(" + activeTab + ") .trader-block"), function(i, e) {
                    var eachThisTab = $(this).index();
                    if (self.scrollTop() >= $(this).context.offsetTop - 45) {
                        $(".content-m-tab:eq(" + activeTab + ") .stage-menu ul li").removeClass('active');
                        $(".content-m-tab:eq(" + activeTab + ") .stage-menu ul li.stage-m-i:eq(" + eachThisTab + ")").addClass('active');
                    }
                });
            }
        });
        $(".stage-m-i").click(function() {
            var myTab = $(this).data('tab'),
                myRow = $(this).text();
            $("body, html").animate({
                scrollTop: $(".content-m-tab:eq(" + myTab + ") .trader-block:nth-child(" + myRow + ")").offset().top - 43
            }, 300);
        });
        $(".stage-menu ul li.stage-m-i").hover(function() {
            var hvIndex = $(this).index();
            var activeTab = $(".content-m-tab.active").index();
            var myTab = $(this).data('tab'),
                myRow = $(this).text();
            console.log(myTab);
            $(".content-m-tab:eq(" + myTab + ") .trader-block:eq(" + (hvIndex - 1) + ")").addClass('hover');
        }, function() {
            var hvIndex = $(this).index();
            var activeTab = $(".content-m-tab.active").index();
            var myTab = $(this).data('tab'),
                myRow = $(this).text();
            $(".content-m-tab:eq(" + myTab + ") .trader-block:eq(" + (hvIndex - 1) + ")").removeClass('hover');
        });

        $(document).click(function(){
            $('.box-popup').removeClass('show');
        });
        $('.box-popup').click(function(e){
            e.stopPropagation();
        });
    }

    $(".Tab-Menu").click(function() {
        if ($(".col-left").hasClass('show')) {
            $(".col-left").removeClass('show');
            $("body").removeClass('menu-left-show');
        } else {
            $(".col-left").addClass('show');
            $("body").addClass('menu-left-show');
        }
    });
    $(".Tab-Char").click(function() {
        $('html, body').animate({
            scrollTop: $("#Login_Content").offset().top
        }, 200);
    });
    $(".Tab-Acc").click(function() {
        if ($(".ResultAcc").hasClass('show')) {
            $(".ResultAcc").removeClass('show');
            $("body").removeClass('menu-left-show');
        } else {
            $(".ResultAcc").addClass('show');
            $("body").addClass('menu-left-show');
        }
    });





    


    $(".menu-collap").click(function() {
        if ($(".wrap-fluid").hasClass('left-collap')) {
            $(".wrap-fluid").removeClass('left-collap');
            $.removeCookie('left-collap');
            $.each($('*[data-title]'), function() {
                $(this).removeAttr('title');
            });
            _initFn();
        } else {
            $(".wrap-fluid").addClass('left-collap');
            $.cookie('left-collap', 1, {
                expires: 365
            });
            $.each($('*[data-title]'), function() {
                $(this).attr('title', $(this).data('title'));
            });
            _initFn();
        }

    });


    $(".select-button-character").click(function() {
        if ($(".dropdown-select").is(':visible'))
            $(".dropdown-select").fadeOut('fast');
        else {
            $(".dropdown-select").fadeIn('fast');
        }

    });

    $("#BlockLeft").on('click', '.head-block-tabs li', function() {
        var myTab = $(this).index();
        $(".head-block-tabs li, .head-sub-tabs .head-sub").removeClass('active');
        $(this).addClass('active');
        $(".head-sub-tabs .head-sub:eq(" + myTab + ")").addClass('active');
    });

    $(".blackBg, .popupClose").click(function() {
        $('.blackBg').hide();
        $(".popupCenter").hide();
        $(".guideShow").removeClass('guideShow');
    });

    $("#Main").on('click', '#chonthe label', function() {
        console.log($(this))
        var this_card = $(this).data('card');
        var text_card = $(this).text();
        $('#text_the').text(text_card);
        $('#logo_the').attr('class', 'logo '+this_card);
    });

    /*$('#box-character li').click(function(){
        var myChar = $(this).data('char');
        $.ajax({
            type: 'POST',
            url: 'index.php',
            data: {
                ChonNV : 'ChonNV',
                nhanvat: myChar
            },
            beforeSend: function(){
                _loading(1);
            },
            success: function(response){
                var hash = window.location.hash;
                if(hash=='char_manager') window.location.reload(1);
                else {
                    window.location.hash = 'char_manager';
                    setTimeout(function(){
                        window.location.reload(1);
                    },10);
                }
            }
        });
    });*/

    _initFn();
    $(document).ajaxComplete(function() {
        _initFn();
    });



});